VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Begin VB.Form Form1 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Form1"
   ClientHeight    =   4830
   ClientLeft      =   2820
   ClientTop       =   1785
   ClientWidth     =   5790
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4830
   ScaleWidth      =   5790
   ShowInTaskbar   =   0   'False
   Begin VB.Timer Timer1 
      Left            =   3600
      Top             =   3600
   End
   Begin VB.CommandButton cmdStartCT 
      Caption         =   "Start Event Count"
      Enabled         =   0   'False
      Height          =   390
      Left            =   675
      TabIndex        =   6
      Top             =   3600
      Width           =   1590
   End
   Begin DlsrLib.DriverLINXSR SRCT 
      Left            =   900
      Top             =   2100
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   2880
      TabIndex        =   4
      Text            =   "0"
      Top             =   720
      Width           =   615
   End
   Begin VB.ListBox List1 
      Height          =   1815
      Left            =   2880
      TabIndex        =   3
      Top             =   1320
      Width           =   1815
   End
   Begin VB.CommandButton cmdSample 
      Caption         =   "Scan 8 AI channels"
      Enabled         =   0   'False
      Height          =   375
      Left            =   720
      TabIndex        =   1
      Top             =   1440
      Width           =   1695
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      Height          =   375
      Left            =   720
      TabIndex        =   0
      Top             =   720
      Width           =   1695
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   1950
      Top             =   2100
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   1350
      Top             =   2100
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label lblCTStatus 
      BackColor       =   &H8000000E&
      Height          =   240
      Left            =   750
      TabIndex        =   8
      Top             =   4200
      Width           =   4065
   End
   Begin VB.Label lblCTCounts 
      BackColor       =   &H8000000E&
      Caption         =   "0"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Left            =   2550
      TabIndex        =   7
      Top             =   3675
      Width           =   765
   End
   Begin VB.Line Line1 
      X1              =   525
      X2              =   5325
      Y1              =   3375
      Y2              =   3375
   End
   Begin VB.Label Label2 
      Caption         =   "Device Number: "
      Height          =   180
      Left            =   2850
      TabIndex        =   5
      Top             =   450
      Width           =   1335
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   300
      Left            =   600
      TabIndex        =   2
      Top             =   120
      Width           =   1455
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit ' require variable declaration

Private Sub cmdInit_Click()
' open the driver and initialize the hardware
With SR
.Req_DLL_name = "kpci3108$"  ' give driver name to avoid Open DriverLINX dialog
.Req_device = devNum.ListIndex
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With
' use of the LDD control is not required
If SR.Res_result = DL_NoErr Then
cmdSample.Enabled = True
cmdStartCT.Enabled = True
cmdInit.Enabled = False
LDD.Req_DLL_name = SR.Req_DLL_name
LDD.device = SR.Req_device
LDD.Refresh
Form1.Caption = "Paced Analog Input and Event Counting with " & LDD.Dev_Model  'from the LDD, determine the model number
Else
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
End If

' initialize the SR control for the Event Counting
SRCT.Req_DLL_name = SR.Req_DLL_name ' assume same board as the AI task
SRCT.Req_device = SR.Req_device

' the LDD control can inform your application
' about the features of the hardware
Form1.SetFocus
End Sub

Private Sub cmdSample_Click()

SetupAIPaced
SR.Refresh  ' do it
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
' see Private Sub SR_BufferFilled() for what happens next
End Sub



Private Sub Form_Load()
' load devNum with legal values
Dim i As Integer
For i = 0 To 5
devNum.AddItem Str(i), i
Next i
' set it to first entry
devNum.ListIndex = 0
End Sub

Private Sub Form_Terminate()
' stop the CT task
With SRCT
    .Req_op = DL_STOP
    .Refresh
End With
' unload the driver for each object
SR.Req_DLL_name = ""
SRCT.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End Sub

Sub SetupAIPaced()
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_DMA  ' could be DL_INTERRUPT if board has no DMA feature
.Req_subsystem = DL_AI
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically when all samples are acquired
.Evt_Tim_type = DL_RATEEVENT ' timing will be used
.Evt_Tim_rateChannel = 3 ' channel 3 of CT is a single 16bit counter of the 82C54
' using 3108-850A04, find that use of DL_DEFAULTTIMER
' causes an interference with the Event Counting task
' that is making use of CT channel 1
' DL_DEFAULTTIMER is channel 0 which is 32bit cascade
' of CT channels 2 and 3.
' Work around is to avoid use of DL_DEFAULTTIMER for pacing the AI task.
.Evt_Tim_rateClock = DL_INTERNAL1       ' internal1 timebase
.Evt_Tim_rateGate = DL_NOCONNECT   ' no gating
.Evt_Tim_rateMode = DL_RATEGEN     ' one sample for each tic of clock
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / 1000) ' 1000 Hz rate
' Select Group
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 2                ' a start channel and stop channel
.Sel_chan_start = 0            ' start on channel 0
.Sel_chan_startGainCode = .DLGain2Code(-1) ' negative = bipolar, 1 = gain of 1
.Sel_chan_stop = 7              'stop on channel 7
.Sel_chan_stopGainCode = .DLGain2Code(-1)
' allocate one buffer of 8 samples for the data
.Sel_buf_N = 1                 ' one buffer used
.Sel_buf_samples = 8
' the buffer MUST be a multiple of how many channels are in the scan, e.g., 8, 16, etc.
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled message
End With
End Sub

Private Sub SR_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)

' allocate array for the data and some other variables that will be needed
Dim AIData(8) As Single  ' still hard coding size of the array/buffers
Dim dummy As Single
Dim i As Integer
List1.Clear  ' clear the list box

' the BufferFilled message contains the bufIndex that is ready for conversion
dummy = SR.VBArrayBufferConvert(bufIndex, 0, 8, AIData, DL_tSINGLE, 0, 0)
For i = 0 To 7
List1.AddItem "chan #: " & Str(i) & "  " & Str(Format(AIData(i), "##.##0"))
Next i
End Sub

Private Sub Timer1_Timer()
With SRCT
.Req_op = DL_STATUS
.Refresh
lblCTCounts.Caption = .Res_Tim_count  'display the result of timer count
End With
End Sub
Private Sub cmdStartCT_Click()
cmdStartCT.Enabled = False

    With SRCT
    .Req_op = DL_START
    .Req_mode = DL_POLLED
    .Req_subsystem = DL_CT
    .Evt_Str_type = DL_COMMAND
    .Evt_Tim_type = DL_RATEEVENT
    .Evt_Tim_rateChannel = 1  ' CT channels of KPCI-3108 are different from KPCI-3101
    '  chan 0 is 32bit cascade of channels 2 and 3.  Channel 1 is the first CT
    ' in the 82C54 chip (CT0).  Input to channel 1 is at pin 20; gate is at pin 19
    .Evt_Tim_rateClock = DL_EXTERNAL  ' will count external signal
    .Evt_Tim_rateGate = DL_DISABLED  ' not using gate
    .Evt_Tim_rateMode = DL_COUNT  ' 16bit event counting
    .Evt_Tim_rateOnCount = 0
    .Evt_Tim_rateOutput = CT_Output_Default
    .Evt_Tim_ratePeriod = 0
    .Evt_Tim_ratePulses = 0
    .Refresh   ' start the task
    End With
    
If SRCT.Res_result = DL_NoErr Then
    lblCTStatus.Caption = "Event Counting Enabled...connect at pin 20"
    Timer1.Interval = 500  ' update every 0.5 seconds
    Timer1.Enabled = True
Else
    lblCTStatus.Caption = SRCT.Message
End If

End Sub
